import * as React from "react"

// import { SearchForm } from '@/components/layout/search-form'
// import { ProfileSwitcher } from '@/components/layout/profile-switcher'
import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarHeader,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
  // SidebarRail,
} from '@/components/ui/sidebar'

import { NavLink, useNavigate } from "react-router-dom"
import Empresas from "@/app/routes/empresas"
import SubEmpresas from "@/app/routes/subempresas"

export function AppSidebar({ ...props }: React.ComponentProps<typeof Sidebar>) {

  const navigate = useNavigate();

  const handleLogout = () => {
    localStorage.removeItem('access_token');
    navigate('/login');
  };

  const data = {
    navMain: [
      {
        title: "Principal",
        url: "#",
        items: [
          {
            title: "Empresas",
            url: "empresas",
            isActive: true,
            element: <Empresas/>
          },
          {
            title: "Sub-Empresas",
            url: "sub-empresas",
            element: <SubEmpresas/>
          },
        ],
      },
      {
        title: "Outros",
        url: "#",
        items: [
          {
            title: "Garagens",
            url: "#",
            element: null,
          },
          {
            title: "Linhas",
            url: "#",
            isActive: false,
            element: null,
          },
          {
            title: "Operações",
            url: "#",
            element: null,
          },
          {
            title: "Regiões",
            url: "#",
            element: null,
          },
          {
            title: "Usuarios",
            url: "#",
            element: null,
          },
          {
            title: "Logout",  // Adicionando item de Logout
            url: "#",
            isActive: false,
            element: null,
            onClick: handleLogout,  // Chamada para função de logout
          },
        ]
      },
    ],
  }


  return (
    
    <Sidebar {...props}>
      <SidebarHeader>
       <div className="flex items-center justify-between">
          <h2 className="text-lg font-semibold">Nome Empresa</h2>
        </div>
      </SidebarHeader>
      <SidebarContent>
        {data.navMain.map((item) => (
          <SidebarGroup key={item.title}>
            <SidebarGroupLabel>{item.title}</SidebarGroupLabel>
            <SidebarGroupContent>
              <SidebarMenu>
                {item.items.map((menuItem) => (
                  <SidebarMenuItem key={menuItem.title}>
                    <SidebarMenuButton asChild isActive={menuItem.isActive}>
                      {menuItem.title === "Logout" ? (
                      <span onClick={handleLogout}>{menuItem.title}</span>
                    ) : (
                      <NavLink to={menuItem.url} end>{menuItem.title}</NavLink>
                    )}
                    </SidebarMenuButton>
                  </SidebarMenuItem>
                ))}
              </SidebarMenu>
            </SidebarGroupContent>
          </SidebarGroup>
        ))}
      </SidebarContent>
    </Sidebar>
  )
}
