import { useEffect } from "react";
import { useNavigate } from 'react-router-dom';
import { LoginForm } from "@/components/ui/login-form"

export default function LoginPage() {
    const navigate = useNavigate();

    useEffect(() => {
        const token = localStorage.getItem('access_token');
        if (token) {
            navigate('/empresas');
        }
    }, [navigate]);

    return (
        <div className="flex min-h-svh w-full items-center justify-center p-6 md:p-10">
            <div className="w-full max-w-sm">
                <LoginForm />
            </div>
        </div>
    )
}